<?php

require_once '../vendor/autoload.php';
require_once '../secrets.php';

header('Content-Type: application/json');

$stripe = new \Stripe\StripeClient([
  // This is your test secret API key.
  "api_key" => $stripeSecretKey,
]);

try {
  $json = file_get_contents('php://input');
  $data = json_decode($json);

  $account_session = $stripe->accountSessions->create([
    'account' => $data->account,
    'components' => [
      'account_onboarding' => [
        'enabled' => true,
      ],
    ],
  ]);

  echo json_encode(array(
    'client_secret' => $account_session->client_secret
  ));
} catch (Exception $e) {
  error_log("An error occurred when calling the Stripe API to create an account session: {$e->getMessage()}");
  http_response_code(500);
  echo json_encode(['error' => $e->getMessage()]);
}

?>